README document for SaxonC-PE 12.6.0:

SaxonC-PE is a compiled variant of Saxon from the Java
platform to the C/C++ platform using GraalVM native-image.

SaxonC-PE provides processing in XSLT 3.0, XQuery 3.1 and
XPath 3.1, and Schema validation 1.0/1.1.

This is a library with APIs for C, C++, PHP, and Python. The main
classes in the SaxonC C++ API are as follows: SaxonProcessor, Xslt30Processor,
XsltExecutable, XQueryProcessor, XPathProcessor, SchemaValidator and
DocumentBuilder.

The following classes provide a subset of the XDM model: XdmValue,
XdmItem, XdmAtomicValue, XdmNode, XdmFunctionItem, XdmArray, and
XdmMap.

The main classes in the SaxonC C API are as follows:

SaxonCGlue.h, SaxonCProcessor.h, SaxonCXPath.h


Full documentation for SaxonC 12 is available. The [SaxonC 12
documentation](https://www.saxonica.com/saxon-c/documentation12/index.html)
contains information specific to SaxonC - including instructions for
installing and configuring the product, details of the SaxonC C/C++
API, PHP API and Python3 API, and sample code. Meanwhile, the main
[Saxon 12 documentation](https://www.saxonica.com/documentation12/index.html)
contains further information relevant to SaxonC.

For further information, see the [SaxonC web
page](https://www.saxonica.com/saxon-c/index.xml). For bug reporting,
lists of known bugs, and help forums, please visit
[https://saxonica.plan.io/](https://saxonica.plan.io/).
